<?php
/**
 * File: api/get_gas_prices.php
 * Purpose: Get current gas prices
 * Author: MEV Pipeline System
 * Last Modified: 2025-11-15
 */

header('Access-Control-Allow-Origin: https://app.poipoe.com');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $pdo = getDatabaseConnection();
    
    $stmt = $pdo->query("
        SELECT 
            safe_gas_price,
            propose_gas_price,
            fast_gas_price,
            base_fee,
            network_utilization,
            timestamp
        FROM gas_tracker
        ORDER BY timestamp DESC
        LIMIT 1
    ");
    
    $data = $stmt->fetch();
    
    if (!$data) {
        throw new Exception("No gas data available");
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'safe' => (int)$data['safe_gas_price'],
            'standard' => (int)$data['propose_gas_price'],
            'fast' => (int)$data['fast_gas_price'],
            'base_fee' => $data['base_fee'],
            'network_utilization' => (float)$data['network_utilization'],
            'last_update' => $data['timestamp']
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Failed to fetch gas prices']);
}
