<?php
/**
 * File: api/get_whale_activity.php
 * Purpose: Get whale movement activity
 * Author: MEV Pipeline System
 * Last Modified: 2025-11-15
 */

header('Access-Control-Allow-Origin: https://app.poipoe.com');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../helpers/Utils.php';

try {
    $limit = isset($_GET['limit']) ? min((int)$_GET['limit'], 100) : 20;
    
    $pdo = getDatabaseConnection();
    
    $stmt = $pdo->prepare("
        SELECT 
            tx_hash,
            token_name,
            token_symbol,
            value,
            value_usd,
            from_address,
            to_address,
            timestamp
        FROM token_transfers
        WHERE is_whale_movement = 1
        ORDER BY timestamp DESC
        LIMIT ?
    ");
    $stmt->execute([$limit]);
    
    $movements = $stmt->fetchAll();
    
    $formatted = array_map(function($m) {
        return [
            'tx_hash' => $m['tx_hash'],
            'token' => $m['token_symbol'] ?? $m['token_name'] ?? 'UNKNOWN',
            'value_usd' => (float)$m['value_usd'],
            'from' => Utils::truncateAddress($m['from_address']),
            'to' => Utils::truncateAddress($m['to_address']),
            'timestamp' => $m['timestamp'],
            'time_ago' => Utils::timeAgo($m['timestamp'])
        ];
    }, $movements);
    
    echo json_encode([
        'success' => true,
        'count' => count($formatted),
        'data' => $formatted
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Failed to fetch whale activity']);
}
