<?php
/**
 * File: api/index.php
 * Purpose: API router and documentation
 * Access: https://core.poipoe.com/mevdata/api/
 * Author: MEV Pipeline System
 * Last Modified: 2025-11-15
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://app.poipoe.com');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$response = [
    'name' => 'MEV Data Pipeline API',
    'version' => '1.0.0',
    'status' => 'operational',
    'timestamp' => date('Y-m-d H:i:s'),
    'endpoints' => [
        [
            'path' => '/api/get_opportunities.php',
            'method' => 'GET',
            'description' => 'Get MEV opportunities',
            'parameters' => [
                'type' => 'Filter by opportunity type (arbitrage, sandwich, liquidation)',
                'min_profit' => 'Minimum net profit in USD',
                'status' => 'Filter by status (pending, executed, expired)',
                'limit' => 'Maximum results (default 50, max 100)',
                'urgency' => 'Filter by urgency level (HIGH, MEDIUM, LOW)'
            ],
            'example' => '/api/get_opportunities.php?status=pending&limit=10&urgency=HIGH'
        ],
        [
            'path' => '/api/get_live_data.php',
            'method' => 'GET',
            'description' => 'Get real-time market data',
            'parameters' => [
                'type' => 'Data type (gas, whale_activity, dex_volume, all)'
            ],
            'example' => '/api/get_live_data.php?type=all'
        ],
        [
            'path' => '/api/get_gas_prices.php',
            'method' => 'GET',
            'description' => 'Get current gas prices',
            'parameters' => [],
            'example' => '/api/get_gas_prices.php'
        ],
        [
            'path' => '/api/get_whale_activity.php',
            'method' => 'GET',
            'description' => 'Get whale movement activity',
            'parameters' => [
                'limit' => 'Number of movements to return (default 20)'
            ],
            'example' => '/api/get_whale_activity.php?limit=10'
        ]
    ],
    'rate_limits' => [
        'requests_per_second' => 10,
        'requests_per_minute' => 300
    ],
    'cors' => [
        'allowed_origins' => ['https://app.poipoe.com'],
        'allowed_methods' => ['GET', 'OPTIONS']
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT);
