<?php
/**
 * File: config/etherscan.php
 * Purpose: Etherscan API configuration
 * Author: MEV Pipeline System
 * Last Modified: 2025-11-15
 */

// Etherscan API configuration
define('ETHERSCAN_API_KEY', 'ZR2CAV375V5R3GCHWYVNZNBZZGTNZ5KH78');
define('ETHERSCAN_API_URL', 'https://api.etherscan.io/api');
define('ETHERSCAN_CHAIN_ID', 1);  // Ethereum Mainnet
define('ETHERSCAN_TIMEOUT', 30);  // API timeout in seconds
define('ETHERSCAN_RETRY_ATTEMPTS', 3);  // Number of retry attempts
define('ETHERSCAN_RETRY_DELAY', 2);  // Seconds between retries

// API rate limits (conservative settings)
define('ETHERSCAN_MAX_CALLS_PER_SECOND', 4);  // Official limit is 5
define('ETHERSCAN_MAX_CALLS_PER_DAY', 80000);  // Official limit is 100,000

// Block range limits for queries
define('MAX_BLOCK_RANGE', 1000);  // Maximum blocks per query
define('DEFAULT_BLOCK_RANGE', 100);  // Default block range

// Event signatures (topic0 hashes)
define('EVENT_SIGNATURES', [
    // ERC20 Transfer event
    'TRANSFER' => '0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef',
    
    // Uniswap V2 Swap event
    'UNISWAP_V2_SWAP' => '0xd78ad95fa46c994b6551d0da85fc275fe613ce37657fb8d5e3d130840159d822',
    
    // Uniswap V3 Swap event
    'UNISWAP_V3_SWAP' => '0xc42079f94a6350d7e6235f29174924f928cc2ac818eb64fed8004e115fbcca67',
    
    // ERC20 Approval event
    'APPROVAL' => '0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925',
]);

// Token decimals (for conversion calculations)
define('TOKEN_DECIMALS', [
    '0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48' => 6,   // USDC
    '0xdAC17F958D2ee523a2206206994597C13D831ec7' => 6,   // USDT
    '0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2' => 18,  // WETH
    '0x6B175474E89094C44Da98b954EedeAC495271d0F' => 18,  // DAI
    '0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599' => 8,   // WBTC
]);

// Approximate USD prices (should be updated from oracle in production)
define('APPROXIMATE_PRICES', [
    '0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48' => 1.00,    // USDC
    '0xdAC17F958D2ee523a2206206994597C13D831ec7' => 1.00,    // USDT
    '0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2' => 3500.00, // WETH (update regularly)
    '0x6B175474E89094C44Da98b954EedeAC495271d0F' => 1.00,    // DAI
    '0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599' => 95000.00, // WBTC (update regularly)
]);
